﻿<%@ Page Title="Patient Imaging" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="PatientImaging.aspx.cs" 
    Inherits="VIRP_WEB.Custom.EFR.PatientImaging" %>

<%@ Import Namespace="System.Net" %>

<asp:Content ID="ContentHead" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>

<asp:Content ID="ContentMain" ContentPlaceHolderID="MainContent" Runat="Server">

    <link href="<%: ResolveUrl("~/Content/Custom/EFR/AccessibleForm.css") %>" rel="stylesheet" />

     <script src="<%: ResolveUrl("~/Scripts/Custom/EFR/patient_imaging.js") %>"></script>

    <script type="text/javascript">

        $(document).ready(function () {

            // *************************************************************************************
            //      Check initial state
            // *************************************************************************************
            var jointSelection = $('#<%=DropDownListJointSpace.ClientID %>').val();
            if (jointSelection === 'true') {
                $('#<%=TextBoxJoint.ClientID%>').prop('disabled', false);
            } else {
                $('#<%=TextBoxJoint.ClientID%>').prop('disabled', true);
                $('#<%=TextBoxJoint.ClientID%>').val('');
            }
            var hasRecord = $('#<%=HiddenFieldHasHistory.ClientID%>').val();
            if (hasRecord) {
                if (hasRecord > 0) {
                    $('#<%=DeleteButton.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=DeleteButton.ClientID%>').prop('disabled', true);
                }
            }

            // *************************************************************************************
            //      DropDownListJointSpace Change Event
            // *************************************************************************************
            $('#<%=DropDownListJointSpace.ClientID %>').on('change', function () {
                
                var jointSelection = $("#<%=DropDownListJointSpace.ClientID %> option:selected").val();
                if (jointSelection === 'true') {
                    $('#<%=TextBoxJoint.ClientID%>').prop('disabled', false);
                } else {
                    $('#<%=TextBoxJoint.ClientID%>').prop('disabled', true);
                    $('#<%=TextBoxJoint.ClientID%>').val('');
                }
            });

            // *************************************************************************************
            //      DropDownListFragmentVerified Change Event
            // *************************************************************************************
            $('#<%=DropDownListFragmentVerified.ClientID %>').on('change', function () {
                
                var verified = $("#<%=DropDownListFragmentVerified.ClientID %> option:selected").val();
                if (verified === 'true') {
                    $('#<%=TextBoxDateImagingReviewedByStaff.ClientID%>').val(getCurrentDate());
                } 
            });

            // *************************************************************************************
            //      HiddenFieldHasHistory Change Event
            // *************************************************************************************
            $('#<%=HiddenFieldHasHistory.ClientID %>').on('change', function () {
                
                var hasRecord = $('#<%=HiddenFieldHasHistory.ClientID%>').val();
                if (hasRecord) {
                    if (hasRecord > 0) {
                        $('#<%=DeleteButton.ClientID%>').prop('disabled', false);
                    } else {
                        $('#<%=DeleteButton.ClientID%>').prop('disabled', true);
                    }
                }
            });

            // **************************************************************************************************
            // When user clicks on a viewer or report link then grab the latest security token for the request
            // **************************************************************************************************
            $('a[name=ImageViewer],a[name=ReportViewer]').click(function (e) {

                e.preventDefault();

                replaceToken($("#<%=RegistryContext.ClientID%>").val(),
                    $("#<%=RegistryId.ClientID%>").val(),
                    $(this).attr('href'));

            }); // $('a[name=...]').click

        }); // $(document).ready

        // *************************************************************************************
        //      getCurrentDate in mm/dd/yyyy format
        // *************************************************************************************
        var getCurrentDate = function () {
            var date = new Date();
            return (date.getMonth() + 1) + '/' + date.getDate() + '/' + date.getFullYear();
        }

        // *************************************************************************************
        //      Check Imaging Status
        // *************************************************************************************
        var checkImagingStatus = function () {

            checkImagingServices($("#<%=RegistryContext.ClientID%>").val(),
                $("#<%=RegistryId.ClientID%>").val());
        }

    </script>

    <!-- ********************************************************************************************** -->
    <!-- Patient Information -->
    <!-- ******************* -->
    <asp:Panel ID="PanelPatientInformation" runat="server" GroupingText="&nbsp;&nbsp;Patient Information&nbsp;&nbsp;" Width="100%">
        <div class="summary-content">
            <div class="lc2">
                <asp:Label ID="LabelPatientName" runat="server" Text="Patient Name:&nbsp;&nbsp;" />
            </div>
            <div class="rc2">
                <asp:Label ID="LabelPatientSnum" runat="server" Text="Patient SSN:&nbsp;&nbsp;" />
            </div>
            <div class="lc2">
                <asp:Label ID="LabelSummaryDateImagingReviewedByStaff" runat="server" Text="Date Imaging Reviewed By Staff:&nbsp;&nbsp;" />
            </div>
            <div class="rc2">
                <asp:Label ID="LabelSummaryFragmentVerified" runat="server" Text="Fragment Verified:&nbsp;&nbsp;" />
            </div>
        </div>
    </asp:Panel>

    <br />
    <br />

    <div id="accessible-form">

        <div id="imageSummaryContainer">

            <!-- ********************************************************************************************** -->
            <!-- Images Fragments Summary -->
            <!-- ************************ -->

            <asp:Panel ID="PanelImagesFragmentSummary" runat="server" GroupingText="&nbsp;&nbsp;Images Fragment Summary&nbsp;&nbsp;" Width="100%">

                <br />
                <br />

                <div class="columns">
                    <div class="lColumn">
                        <asp:Label runat="server" role="application" ID="LabelImageType" AssociatedControlID="DropDownListInCprs" Text="Are Images and/or Imaging Reports Available Within CPRS:" Width="500"/>
                        <asp:DropDownList ID="DropDownListInCprs" runat="server" ToolTip="Are Images and/or Imaging Reports Available Within CPRS, Select Yes or No" OnClientLoad="cats();">
                            <asp:ListItem Text="Select a Value" />
                            <asp:ListItem Text="Yes" Value="true" />
                            <asp:ListItem Text="No" Value="false" />
                        </asp:DropDownList>
                    </div>
                    <div class="rColumn">
                        <asp:Label runat="server" ID="LabelFragmentVerified" AssociatedControlID="DropDownListFragmentVerified" Text="Fragment Verified:" Width="500" />
                        <asp:DropDownList ID="DropDownListFragmentVerified" runat="server" ToolTip="Fragment Verified, Select Yes or No" >
                            <asp:ListItem Text="Select a Value" />
                            <asp:ListItem Text="Yes" Value="true" />
                            <asp:ListItem Text="No" Value="false" />
                        </asp:DropDownList>
                    </div>
                </div>
       
                <div class="clear-float"></div>
                <br />
                <br />

                <div class="columns">
                    <div class="lColumn">
                        <asp:Label runat="server" ID="LabelBoneFracture" AssociatedControlID="DropDownListBoneFracture" Text="Is There Documentation of a Bone Fracture:" Width="500"/>
                        <asp:DropDownList ID="DropDownListBoneFracture" runat="server" ToolTip="Is There Documentation of a Bone Fracture, Select Yes or No" >
                            <asp:ListItem Text="Select a Value" />
                            <asp:ListItem Text="Yes" Value="true" />
                            <asp:ListItem Text="No" Value="false" />
                        </asp:DropDownList>
                    </div>
                    <div class="rColumn">
                        <asp:Label runat="server" ID="LabelFragmentSize" AssociatedControlID="DropDownListFragmentSize" Text="Are the Majority of Fragments Predominately:" Width="500" />
                        <asp:DropDownList ID="DropDownListFragmentSize" runat="server" ToolTip="Are the Majority of Fragments Predominately, Select Size Range" >
                            <asp:ListItem Text="Select a Value" />
                            <asp:ListItem Text="Less Than 3mm" Value="small" />
                            <asp:ListItem Text="Between 3mm And 10mm" Value="medium" />
                            <asp:ListItem Text="Greater Than 10mm" Value="large" />
                        </asp:DropDownList>
                    </div>
                </div>

                <div class="clear-float"></div>
                <br />
                <br />

                <div class="columns">
                    <div class="lColumn">
                        <asp:Label  runat="server" ID="LabelJointSpace" AssociatedControlID="DropDownListJointSpace" Text="Are Any of the Fragments Located Within a Joint Space:" Width="500" />
                        <asp:DropDownList ID="DropDownListJointSpace" runat="server" ToolTip="Are Any of the Fragments Located Within a Joint Space, Select Yes or No">
                            <asp:ListItem Text="Select a Value" />
                            <asp:ListItem Text="Yes" Value="true" />
                            <asp:ListItem Text="No" Value="false" />
                        </asp:DropDownList>
                    </div>
                    <div class="rColumn">
                        <asp:Label runat="server" ID="LabelJoint" AssociatedControlID="TextBoxJoint" Text="Joint: " Width="500" />
                        <asp:TextBox runat="server"  ID="TextBoxJoint" EmptyMessage="Enter Joint Details" ToolTip="Enter Joint Details" />
                    </div>
                </div>

                <div class="clear-float"></div>
                <br />
                <br />

                <br />
                <div class="left-float">
                    <asp:Label ID="LabelDateImagingReviewedByStaff" runat="server" Text="Date Imaging Reviewed by Staff:" AssociatedControlID="TextBoxDateImagingReviewedByStaff" />
                    <asp:TextBox ID="TextBoxDateImagingReviewedByStaff" runat="server" ToolTip="Enter Date Imaging Reviewed by Staff" MaxLength="10" onkeypress="return CheckDate(event);"/>
                    <ajax:CalendarExtender runat="server" ID="CalendarExtenderDateImagingReviewedByStaff" Animated="true" TargetControlID="TextBoxDateImagingReviewedByStaff" />
                </div>
                
                <div class="clear-float"></div>
                <br />
                <br />

                <div class="left-float">
                    <asp:Label ID="LabelComments"  runat="server" AssociatedControlID="TextBoxOtherObservations" Text="Other Fragment Related Observations: " />
                    <asp:TextBox ID="TextBoxOtherObservations"  runat="server" MaxLength="2000" TextMode="MultiLine" Rows="5" ToolTip="Enter Other Fragment Related Observations" Width="1000" />
                </div>

            </asp:Panel>

        </div> <!-- imageSummaryContainer -->
    </div> <!-- accessible-form -->

    <div class="clear-float"></div>
    <br />
    <br />

    <asp:Button runat="server" ID="SaveButton" Text="Save" OnClick="SaveButton_Click" UseSubmitBehavior="true" ToolTip="Save Entries." />
    &nbsp;&nbsp;
    <asp:Button runat="server" ID="DeleteButton" Text="Delete" OnClick="DeleteButton_Click" OnClientClick="return confirm('Are you certain you want to delete this record?');" UseSubmitBehavior="true" CausesValidation="false" ToolTip="Delete Record."/>

    <br />
    <br />

    <asp:Panel ID="PanelImagingStatus" runat="server" GroupingText="&nbsp;&nbsp;Imaging Status&nbsp;&nbsp;" Width="500" >
        <div id="ImagingStatus"></div>
    </asp:Panel>

    <br />
    <br />

    <asp:GridView ID="GridImages" runat="server" EmptyDataText="Currently no images are available for this patient." 
        CssClass="gridRegistry" PagerStyle-CssClass="pager" DataSourceID = "ObjectDataSourcePatientsImages"
        OnDataBound="GridImages_DataBound" OnRowDataBound="GridImages_RowDataBound"
        EmptyDataRowStyle-CssClass="gridRegistryEmpty" AutoGenerateColumns="false" AllowSorting="true" AllowPaging="true" PageSize="10" Width="100%">
        <Columns>
            <asp:BoundField DataField="PATIENT_ID" Visible="false" />
            <asp:BoundField DataField="PATIENT_IMAGE_ID" Visible="false" />
            <asp:BoundField DataField="VIEWER_URL" Visible="false" />
            <asp:BoundField DataField="REPORT_URL" Visible="false" />
            <asp:BoundField DataField="STUDY_DATE" HeaderText="Study Date" SortExpression="STUDY_DATE" />
            <asp:BoundField DataField="SYSTEM_IDENTIFIED_FRAGMENT" HeaderText="System Identified Fragment" SortExpression="SYSTEM_IDENTIFIED_FRAGMENT_FLAG" />
            <asp:BoundField DataField="FRAGMENT_VERIFIED" HeaderText="Fragment Verified"  SortExpression="FRAGMENT_VERIFIED" />
            <asp:BoundField DataField="REVIEWED" HeaderText="Reviewed"  SortExpression="REVIEWED" />
            <asp:BoundField DataField="IMAGE_COUNT" HeaderText="Image Count"  SortExpression="IMAGE_COUNT" />
            <asp:BoundField DataField="STUDY_DESCRIPTION" HeaderText="Study Description"  SortExpression="STUDY_DESCRIPTION" />
            <asp:BoundField DataField="IMAGE_FRAGMENT_COUNT_DESCRIPTION_TEXT" HeaderText="Image Fragment Count"  SortExpression="IMAGE_FRAGMENT_COUNT_DESCRIPTION_TEXT" />
            
            <asp:TemplateField HeaderText="Body Part(s) Imaged" SortExpression="ImageBodyParts" >
                <ItemTemplate><%#GetBodyPartsImaged(DataBinder.Eval(Container.DataItem, "PATIENT_IMAGE_ID"))%></ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="View Image" ControlStyle-Width="100px" ItemStyle-Width="100px">
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLinkImageViewer" Name="ImageViewer" runat="server" Text="Image Viewer" Target="_blank" />
                    <asp:Label ID="LabelImageViewer" runat="server" />
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="View Report" ControlStyle-Width="100px" ItemStyle-Width="100px" >
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLinkReportViewer" Name="ReportViewer" runat="server" Text="Report Viewer" Target="_blank" />
                    <asp:Label ID="LabelReportViewer" runat="server" />
                </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="View\Edit Details" ControlStyle-Width="100px" ItemStyle-Width="100px" >
                <ItemTemplate>
                    <a href="<%#GetDetailsLink(Eval("PATIENT_ID"), Eval("PATIENT_IMAGE_ID"))%>">Details</a>
                </ItemTemplate>
            </asp:TemplateField>

        </Columns>
    </asp:GridView>

    <asp:ObjectDataSource ID="ObjectDataSourcePatientsImages" runat="server" 
        SelectMethod="GetImagesForPatient" 
        SelectCountMethod="GetImagesForPatientCount" 
        EnableViewState="true"
        StartRowIndexParameterName="START_ROW" 
        MaximumRowsParameterName="MAX_ROWS" 
        EnablePaging="True" 
        TypeName="VIRP.EFR.BLL.PatientImagingManager"
        DataObjectTypeName="VIRP.EFR.BO.PatientImageView">               
        <SelectParameters>
            <asp:Parameter Name="PATIENT_ID" Type="Int32" />
            <asp:Parameter Name="PATIENT_ICN" Type="String" />
            <asp:Parameter Name="START_ROW" Type="Int32" />
            <asp:Parameter Name="MAX_ROWS" Type="Int32" />
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <br /><br /><br /><br />

    <asp:LinkButton ID="LinkButtonPatientInformation" runat="server" Text="Patient Information" ToolTip="Select to see patient information" style="padding:4px; border:1px solid white;" OnClick="LinkButtonPatientInformation_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonWorkflows" runat="server" Text="Workflows" ToolTip="Select to see workflows for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonWorkflows_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonRelatedDiagnoses" runat="server" Text="Related Diagnoses" ToolTip="Select to see related diagnoses for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonRelatedDiagnoses_Click" />&nbsp;
    <asp:LinkButton ID="LinkButtonLabTests" runat="server" Text="Lab Tests" ToolTip="Select to see lab tests for patient" style="padding:4px; border:1px solid white;" OnClick="LinkButtonLabTests_Click" />&nbsp;

    <!-- ********************************************************************************************** -->
    <!-- Other -->
    <div id="hidden">
        <asp:HiddenField runat="server" ID="PageSaveCount" Value="0"/>
        <asp:HiddenField runat="server" ID="HiddenFieldHasHistory" Value="0"/>
        <asp:HiddenField runat="server" ID="RegistryContext" Value=""/>
        <asp:HiddenField runat="server" ID="RegistryId" Value=""/>
    </div>

</asp:Content>
